/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.servlet.logd;

import com.ibm.hwmca.base.util.BaseFileControl;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.util.Trace;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;

public class GetDisplayerName {
    private static final String TRACE_MASKT = "XLDSGENT";
    private static final String TRACE_MASKD = "XLDSGEND";
    private static final String TRACE_MASKF = "XLDSGENF";
    private static final FrameworkClassLogInfo _logInfo = new FrameworkClassLogInfo(85, "LogdServ");
    private static final String CLASS_MAP_FILE = "LogServletClassMap.properties";
    private static final String DLL_MAP_FILE = "LogServletDllMap.properties";
    private static final String DEFAULT_DISPLAY_CLASS = "com.ibm.hwmca.fw.servlet.logd.HexExpander";

    protected static String getDisplayerName(Properties classMap, String logClass, String logType, String logBlockId, String whoAmI, boolean classMapOk) {
        Trace.trace(TRACE_MASKF, whoAmI + "getDisplayerName with properties file");
        String displayerName = DEFAULT_DISPLAY_CLASS;
        if (classMapOk) {
            displayerName = GetDisplayerName.getName(classMap, logClass, logType, logBlockId, whoAmI);
        } else {
            Trace.trace(TRACE_MASKF, whoAmI + "had been unable to retrieve the log class map file");
        }
        if (displayerName == null) {
            displayerName = DEFAULT_DISPLAY_CLASS;
        }
        Trace.trace(TRACE_MASKF, whoAmI + "log displayer expander class=[" + displayerName + "]");
        return displayerName;
    }

    protected static String getDisplayerName(String classMapStr, String logClass, String logType, String logBlockId, String whoAmI) {
        String displayerName = null;
        Trace.trace(TRACE_MASKF, whoAmI + "getDisplayerName  classMapStr=" + classMapStr);
        try {
            Properties classMapProperties = GetDisplayerName.getMapping(classMapStr, whoAmI);
            displayerName = GetDisplayerName.getName(classMapProperties, logClass, logType, logBlockId, whoAmI);
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, whoAmI + "caught exc in getDisplayerName");
            Trace.trace(TRACE_MASKF, e);
            displayerName = null;
        }
        return displayerName;
    }

    protected static Properties getMapping(String mapName, String whoAmI) throws HException, FileNotFoundException, IOException {
        String filePath = BaseFileControl.getFilePath(mapName);
        Properties properties = null;
        FileInputStream is = null;
        String fileName = filePath + mapName;
        Trace.trace(TRACE_MASKF, whoAmI + " Name of the log class map file=" + fileName);
        is = new FileInputStream(fileName);
        properties = new Properties();
        properties.load(is);
        return properties;
    }

    private static String getName(Properties classMap, String logClass, String logType, String logBlockId, String whoAmI) {
        Trace.trace(TRACE_MASKF, "-> GetDisplayerName.getName() for:" + whoAmI);
        Properties properties = new Properties();
        boolean continueProcessing = true;
        String displayerName = null;
        String fileName = null;
        if (logBlockId.length() == 1) {
            logBlockId = "0" + logBlockId;
        }
        String key = (logClass + "_" + logType + "_" + logBlockId).toUpperCase();
        Trace.trace(TRACE_MASKF, whoAmI + "log expander: KEY=" + key);
        fileName = classMap.getProperty(logClass.toUpperCase().trim());
        if (fileName != null) {
            Trace.trace(TRACE_MASKF, whoAmI + "logExpanderClass=[" + fileName + "]");
            FileInputStream is = null;
            try {
                is = new FileInputStream(fileName);
                properties.load(is);
            }
            catch (FileNotFoundException fnfe) {
                continueProcessing = false;
                Trace.trace(TRACE_MASKF, whoAmI + "log expander file =[" + fileName + "] not found");
                Trace.trace(TRACE_MASKF, "exc=" + fnfe);
            }
            catch (IOException ioe) {
                continueProcessing = false;
                Trace.trace(TRACE_MASKF, whoAmI + "io exc=" + ioe);
            }
            if (continueProcessing && (displayerName = properties.getProperty(key)) == null && (displayerName = properties.getProperty(key = (logClass + "_" + "*" + "_" + logBlockId).toUpperCase())) == null) {
                key = (logClass + "_" + logType + "_" + "*").toUpperCase();
                displayerName = properties.getProperty(key);
                if (displayerName == null) {
                    key = (logClass + "_" + "*" + "_" + "*").toUpperCase();
                    displayerName = properties.getProperty(key);
                }
                if (displayerName == null) {
                    Trace.trace(TRACE_MASKF, whoAmI + "log class key not found in properties file");
                }
            }
        } else {
            Trace.trace(TRACE_MASKF, whoAmI + "logClass=[" + logClass + "] not found in log class map properties");
        }
        if (displayerName != null) {
            Trace.trace(TRACE_MASKF, "log displayer expander class=[" + displayerName + "]");
            displayerName = displayerName.trim();
            Trace.trace(TRACE_MASKF, "trimed class=[" + displayerName + "]");
        }
        Trace.trace(TRACE_MASKF, "<- GetDisplayerName.getName() for:" + whoAmI);
        return displayerName;
    }
}

